define([
    'modules/new-appointment-request/resources/direct/clinics/collection',
    'modules/new-appointment-request/resources/direct/preferred-date/clinics-time-slots-collections',
    'modules/new-appointment-request/tests/helpers/clinics-helper',
], function(Collection, SlotsCollection, helpers) {
    'use strict';

    describe('New Appointment Clinics Collection', function() {
        var clinics;


        beforeEach(function() {
            clinics = helpers.getMockClinicList();
            helpers.getMockClinicList();
            helpers.collectionFetchSpy(clinics);
        });

        it('generates the correct url', function() {
            var collection = new Collection();
            var url = collection.url();
            var expectedUrl = 'base-url/VeteranAppointmentRequestService/v4/rest/clinical-services/clinics';

            expect(url).toBe(expectedUrl);
        });

        it('generates the correct fetch data', function() {
            var collection = new Collection();
            var service = 'test';
            collection.listenTo(collection, 'fetch:success', function(c, response, options) {
                expect(options.data['clinical-service']).toBe(service);
            });
            collection.fetchClinics('123', '123', service);
        });

        it('maps to a string list correctly', function() {
            var collection = new Collection();
            var expected = '3,2,1';

            collection.fetchClinics('123', '123', '123');

            expect(collection.toStringList()).toBe(expected);
        });
    });
});
